<?php
/**
 * Announcements API Endpoint
 * Retrieves announcements for a specific class or all announcements
 */

header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/Database.php';

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    $db = new Database();
    $pdo = $db->connect();

    try {
        $student_id = isset($_GET['student_id']) ? filter_var($_GET['student_id'], FILTER_SANITIZE_NUMBER_INT) : null;
        $limit = isset($_GET['limit']) ? filter_var($_GET['limit'], FILTER_SANITIZE_NUMBER_INT) : 20;

        // Get student's class if student_id provided
        $class_id = null;
        if ($student_id) {
            $class_query = "SELECT class_id FROM students WHERE id = :student_id LIMIT 1";
            $class_stmt = $pdo->prepare($class_query);
            $class_stmt->bindParam(':student_id', $student_id);
            $class_stmt->execute();
            $student_class = $class_stmt->fetch(PDO::FETCH_ASSOC);
            $class_id = $student_class['class_id'] ?? null;
        }

        // Get announcements - general or class-specific
        $query = "SELECT 
                    id,
                    title,
                    content,
                    type,
                    priority,
                    created_at,
                    expires_at
                  FROM announcements
                  WHERE (target_class_id IS NULL OR target_class_id = :class_id)
                  AND (expires_at IS NULL OR expires_at > NOW())
                  ORDER BY priority DESC, created_at DESC
                  LIMIT :limit";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
        
        if ($class_id) {
            $stmt->bindParam(':class_id', $class_id, PDO::PARAM_INT);
        } else {
            $stmt->bindValue(':class_id', null, PDO::PARAM_NULL);
        }
        
        $stmt->execute();
        $announcements = $stmt->fetchAll(PDO::FETCH_ASSOC);

        echo json_encode([
            'success' => true,
            'data' => $announcements
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'message' => 'Error: ' . $e->getMessage()
        ]);
    }
} else {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Method not allowed'
    ]);
}
?>
