<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once '../config/Database.php';

$action = $_GET['action'] ?? 'getStudentAssignments';
$student_id = isset($_GET['student_id']) ? intval($_GET['student_id']) : 1;
$class_id = isset($_GET['class_id']) ? intval($_GET['class_id']) : 1;

$db = new Database();
$pdo = $db->connect();

try {
    if ($action === 'getStudentAssignments') {
        // Get assignments for a student with their submission status
        $query = "
            SELECT DISTINCT
                a.id as assignment_id,
                a.subject_id,
                a.title,
                a.description,
                a.assignment_type,
                a.due_date,
                a.total_marks,
                s.subject_name,
                u.full_name as teacher_name,
                COALESCE(asub.submission_status, 'pending') as submission_status,
                asub.marks_obtained,
                asub.submission_date
            FROM assignments a
            INNER JOIN subjects s ON a.subject_id = s.id
            INNER JOIN users u ON a.teacher_id = u.id
            INNER JOIN students stu ON stu.class_id = a.class_id AND stu.id = :student_id
            LEFT JOIN assignment_submissions asub ON a.id = asub.assignment_id AND asub.student_id = stu.id
            ORDER BY a.due_date DESC
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindValue(':student_id', $student_id, PDO::PARAM_INT);
        $stmt->execute();
        $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Assignments retrieved successfully',
            'data' => $assignments
        ]);
        
    } elseif ($action === 'getAssignments') {
        // Get all assignments for a class (homework view)
        $query = "
            SELECT 
                a.id as assignment_id,
                a.subject_id,
                a.title,
                a.description,
                a.assignment_type,
                a.due_date,
                a.total_marks,
                s.subject_name,
                u.full_name as teacher_name
            FROM assignments a
            INNER JOIN subjects s ON a.subject_id = s.id
            INNER JOIN users u ON a.teacher_id = u.id
            WHERE a.class_id = :class_id
            ORDER BY a.due_date DESC
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindValue(':class_id', $class_id, PDO::PARAM_INT);
        $stmt->execute();
        $assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Assignments retrieved successfully',
            'data' => $assignments
        ]);
    } else {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Invalid action: ' . $action
        ]);
    }
} catch (PDOException $e) {
    http_response_code(500);
    error_log('API Assignments Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    error_log('API Assignments Exception: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}

