<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once '../config/Database.php';

$action = $_GET['action'] ?? 'getLatestReportCard';
$student_id = $_GET['student_id'] ?? 1;

$db = new Database();
$pdo = $db->connect();

try {
    if ($action === 'getLatestReportCard') {
        // Get latest results for student grouped by term and session
        $query = "
            SELECT 
                r.id as report_card_id,
                r.student_id,
                r.session_year as academic_year,
                r.term as academic_term,
                GROUP_CONCAT(r.subject SEPARATOR ', ') as subjects,
                AVG(r.total) as gpa,
                MIN(r.position_in_class) as class_position,
                GROUP_CONCAT(r.grade SEPARATOR ',') as grades,
                GROUP_CONCAT(r.teacher_remark SEPARATOR ' | ') as teacher_comments
            FROM results r
            WHERE r.student_id = :student_id
            GROUP BY r.session_year, r.term
            ORDER BY r.session_year DESC, 
                     FIELD(r.term, '3rd', '2nd', '1st')
            LIMIT 1
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindValue(':student_id', $student_id, PDO::PARAM_INT);
        $stmt->execute();
        $reportCard = $stmt->fetch(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Report card retrieved successfully',
            'data' => $reportCard ? [$reportCard] : []
        ]);
        
    } elseif ($action === 'getReportCard') {
        // Get all results for student grouped by term
        $query = "
            SELECT 
                MIN(r.id) as report_card_id,
                r.student_id,
                r.session_year as academic_year,
                r.term as academic_term,
                GROUP_CONCAT(r.subject SEPARATOR ', ') as subjects,
                AVG(r.total) as gpa,
                MIN(r.position_in_class) as class_position,
                GROUP_CONCAT(r.grade SEPARATOR ',') as grades,
                GROUP_CONCAT(r.teacher_remark SEPARATOR ' | ') as teacher_comments
            FROM results r
            WHERE r.student_id = :student_id
            GROUP BY r.session_year, r.term
            ORDER BY r.session_year DESC, 
                     FIELD(r.term, '3rd', '2nd', '1st')
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindValue(':student_id', $student_id, PDO::PARAM_INT);
        $stmt->execute();
        $reportCards = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Report cards retrieved successfully',
            'data' => $reportCards
        ]);
    }
} catch (PDOException $e) {
    http_response_code(500);
    error_log('API Report Card Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    error_log('API Report Card Exception: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
