<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once '../config/Database.php';

$action = $_GET['action'] ?? 'getTimetable';
$student_id = $_GET['student_id'] ?? 1;

$db = new Database();
$pdo = $db->connect();

try {
    if ($action === 'getTimetable') {
        // Get timetable organized by day and time
        $query = "
            SELECT 
                t.id as timetable_id,
                t.class_id,
                t.subject_id,
                t.day_of_week,
                t.start_time,
                t.end_time,
                t.room_number,
                s.subject_name,
                u.full_name as teacher_name
            FROM timetable t
            JOIN subjects s ON t.subject_id = s.id
            JOIN users u ON t.teacher_id = u.id
            JOIN students stu ON stu.class_id = t.class_id
            WHERE stu.id = :student_id
            ORDER BY 
                FIELD(t.day_of_week, 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'),
                t.start_time
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':student_id', $student_id, PDO::PARAM_INT);
        $stmt->execute();
        $timetable = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Timetable retrieved successfully',
            'data' => $timetable
        ]);
        
    } elseif ($action === 'getSubjects') {
        // Get subjects for student's class
        $query = "
            SELECT 
                s.id as subject_id,
                s.subject_name,
                s.subject_code,
                s.credit_hours,
                s.description,
                u.full_name as teacher_name
            FROM subjects s
            JOIN students stu ON stu.class_id = s.class_id
            LEFT JOIN users u ON s.teacher_id = u.id
            WHERE stu.id = :student_id
            ORDER BY s.subject_name
        ";
        
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':student_id', $student_id, PDO::PARAM_INT);
        $stmt->execute();
        $subjects = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Subjects retrieved successfully',
            'data' => $subjects
        ]);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>
