<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

require_once '../config/Database.php';

$parent_id = $_GET['parent_id'] ?? null;

if (!$parent_id) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'parent_id is required'
    ]);
    exit;
}

$db = new Database();
$pdo = $db->connect();

try {
    // Get all students linked to this parent
    $query = "
        SELECT 
            s.id,
            s.admission_number,
            s.full_name,
            s.gender,
            s.class_id,
            c.class_name,
            c.section,
            s.photo_url,
            ps.relationship,
            ps.is_primary
        FROM students s
        INNER JOIN classes c ON s.class_id = c.id
        INNER JOIN parent_student ps ON s.id = ps.student_id
        WHERE ps.parent_id = :parent_id
        ORDER BY ps.is_primary DESC, s.full_name ASC
    ";
    
    $stmt = $pdo->prepare($query);
    $stmt->bindValue(':parent_id', $parent_id, PDO::PARAM_INT);
    $stmt->execute();
    $students = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'message' => 'Students retrieved successfully',
        'data' => $students
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    error_log('API Parent Students Error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    error_log('API Parent Students Exception: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>
