<?php
/**
 * Results API Endpoint
 * Retrieves academic results for a student
 */

header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/Database.php';

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    $db = new Database();
    $pdo = $db->connect();

    if (isset($_GET['student_id']) && !empty($_GET['student_id'])) {
        $student_id = filter_var($_GET['student_id'], FILTER_SANITIZE_NUMBER_INT);
        
        // Optional filters
        $session_year = isset($_GET['session_year']) ? filter_var($_GET['session_year'], FILTER_SANITIZE_STRING) : null;
        $term = isset($_GET['term']) ? filter_var($_GET['term'], FILTER_SANITIZE_STRING) : null;
        
        try {
            $query = "SELECT 
                        subject,
                        ca1,
                        ca2,
                        exam,
                        total,
                        grade,
                        position_in_class,
                        session_year,
                        term,
                        teacher_remark
                      FROM results
                      WHERE student_id = :student_id";
            
            if ($session_year) {
                $query .= " AND session_year = :session_year";
            }
            if ($term) {
                $query .= " AND term = :term";
            }
            
            $query .= " ORDER BY session_year DESC, term DESC, subject ASC";
            
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':student_id', $student_id);
            
            if ($session_year) {
                $stmt->bindParam(':session_year', $session_year);
            }
            if ($term) {
                $stmt->bindParam(':term', $term);
            }
            
            $stmt->execute();
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode([
                'success' => true,
                'data' => $results
            ]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'message' => 'Error: ' . $e->getMessage()
            ]);
        }
    } else {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Student ID is required'
        ]);
    }
} else {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Method not allowed'
    ]);
}
?>
