<?php
/**
 * Student API Endpoint
 * Retrieves student and parent information
 */

header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/Database.php';

// Get student by ID or admission number
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    $db = new Database();
    $pdo = $db->connect();

    // Check if student_id or admission_number is provided
    if (isset($_GET['student_id']) && !empty($_GET['student_id'])) {
        $student_id = filter_var($_GET['student_id'], FILTER_SANITIZE_NUMBER_INT);
        
        try {
            $query = "SELECT s.*, c.class_name, c.section 
                      FROM students s 
                      LEFT JOIN classes c ON s.class_id = c.id 
                      WHERE s.id = :id LIMIT 1";
            
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':id', $student_id);
            $stmt->execute();
            
            $student = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($student) {
                // Get parent information
                $parent_query = "SELECT u.id, u.full_name, u.email, u.phone, ps.relationship
                                FROM parent_student ps
                                JOIN users u ON ps.parent_id = u.id
                                WHERE ps.student_id = :student_id";
                
                $parent_stmt = $pdo->prepare($parent_query);
                $parent_stmt->bindParam(':student_id', $student_id);
                $parent_stmt->execute();
                
                $parents = $parent_stmt->fetchAll(PDO::FETCH_ASSOC);
                
                echo json_encode([
                    'success' => true,
                    'data' => [
                        'student' => $student,
                        'parents' => $parents
                    ]
                ]);
            } else {
                http_response_code(404);
                echo json_encode([
                    'success' => false,
                    'message' => 'Student not found'
                ]);
            }
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'message' => 'Error: ' . $e->getMessage()
            ]);
        }
    } else {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Student ID is required'
        ]);
    }
} else {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Method not allowed'
    ]);
}
?>
