<?php
// api_activities.php - Extracurricular Activities API Endpoint

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

$request_method = $_SERVER['REQUEST_METHOD'];
$action = isset($_GET['action']) ? $_GET['action'] : '';

// Database connection
$db_host = 'localhost';
$db_user = 'root';
$db_pass = '';
$db_name = 'school_portal';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit();
}

if ($request_method === 'GET') {
    if ($action === 'getActivities') {
        try {
            $query = "SELECT 
                ea.id, ea.activity_name, ea.activity_type, ea.description, 
                ea.meeting_day, ea.meeting_time, ea.location,
                u.full_name as coordinator_name
            FROM extracurricular_activities ea
            LEFT JOIN users u ON ea.coordinator_id = u.id
            WHERE ea.is_active = 1
            ORDER BY ea.activity_type ASC, ea.activity_name ASC";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute();
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'activities' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
    elseif ($action === 'getStudentActivities') {
        $studentId = isset($_GET['student_id']) ? intval($_GET['student_id']) : 1;
        
        try {
            $query = "SELECT 
                ea.id, ea.activity_name, ea.activity_type, ea.description, 
                ea.meeting_day, ea.meeting_time, ea.location,
                ap.join_date, ap.status, ap.participation_level, ap.achievements,
                u.full_name as coordinator_name
            FROM activity_participation ap
            JOIN extracurricular_activities ea ON ap.activity_id = ea.id
            LEFT JOIN users u ON ea.coordinator_id = u.id
            WHERE ap.student_id = :student_id AND ea.is_active = 1
            ORDER BY ea.activity_type ASC";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute(['student_id' => $studentId]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'activities' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
}
?>
