<?php
// api_assignments.php - Assignments/Homework API Endpoint

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

$request_method = $_SERVER['REQUEST_METHOD'];
$action = isset($_GET['action']) ? $_GET['action'] : '';

// Database connection
$db_host = 'localhost';
$db_user = 'root';
$db_pass = '';
$db_name = 'school_portal';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit();
}

if ($request_method === 'GET') {
    if ($action === 'getAssignments') {
        $classId = isset($_GET['class_id']) ? intval($_GET['class_id']) : 1;
        
        try {
            $query = "SELECT 
                a.id, a.title, a.description, a.assignment_type, a.assigned_date, a.due_date, a.total_marks,
                s.subject_name,
                u.full_name as teacher_name
            FROM assignments a
            JOIN subjects s ON a.subject_id = s.id
            JOIN users u ON a.teacher_id = u.id
            WHERE a.class_id = :class_id
            ORDER BY a.due_date ASC";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute(['class_id' => $classId]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'assignments' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
    elseif ($action === 'getStudentAssignments') {
        $studentId = isset($_GET['student_id']) ? intval($_GET['student_id']) : 1;
        
        try {
            $query = "SELECT 
                a.id, a.title, a.description, a.assignment_type, a.assigned_date, a.due_date, a.total_marks,
                s.subject_name,
                u.full_name as teacher_name,
                COALESCE(asub.submission_status, 'pending') as submission_status,
                COALESCE(asub.marks_obtained, NULL) as marks_obtained,
                asub.submission_date
            FROM assignments a
            JOIN subjects s ON a.subject_id = s.id
            JOIN users u ON a.teacher_id = u.id
            JOIN students st ON a.class_id = st.class_id
            LEFT JOIN assignment_submissions asub ON a.id = asub.assignment_id AND asub.student_id = :student_id
            WHERE st.id = :student_id
            ORDER BY a.due_date ASC";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute(['student_id' => $studentId]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'assignments' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
}
?>
