<?php
// api_events.php - Events/Calendar API Endpoint

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

$request_method = $_SERVER['REQUEST_METHOD'];
$action = isset($_GET['action']) ? $_GET['action'] : '';

// Database connection
$db_host = 'localhost';
$db_user = 'root';
$db_pass = '';
$db_name = 'school_portal';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit();
}

if ($request_method === 'GET') {
    if ($action === 'getEvents') {
        $month = isset($_GET['month']) ? intval($_GET['month']) : date('m');
        $year = isset($_GET['year']) ? intval($_GET['year']) : date('Y');
        
        try {
            $query = "SELECT 
                id, event_name, event_description, event_type, event_date, start_time, end_time, location
            FROM events
            WHERE MONTH(event_date) = :month AND YEAR(event_date) = :year AND is_public = 1
            ORDER BY event_date ASC";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute(['month' => $month, 'year' => $year]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'events' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
    elseif ($action === 'getUpcomingEvents') {
        $limit = isset($_GET['limit']) ? intval($_GET['limit']) : 10;
        
        try {
            $query = "SELECT 
                id, event_name, event_description, event_type, event_date, start_time, end_time, location
            FROM events
            WHERE event_date >= CURDATE() AND is_public = 1
            ORDER BY event_date ASC
            LIMIT :limit";
            
            $stmt = $pdo->prepare($query);
            $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
            $stmt->execute();
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'events' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
}
?>
