<?php
// api_library.php - Library API Endpoint

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

$request_method = $_SERVER['REQUEST_METHOD'];
$action = isset($_GET['action']) ? $_GET['action'] : '';

// Database connection
$db_host = 'localhost';
$db_user = 'root';
$db_pass = '';
$db_name = 'school_portal';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit();
}

if ($request_method === 'GET') {
    if ($action === 'getBooks') {
        $category = isset($_GET['category']) ? $_GET['category'] : '';
        
        try {
            if ($category) {
                $query = "SELECT 
                    id, book_title, book_author, isbn, category, publication_year, available_copies, total_copies
                FROM library_books
                WHERE category = :category
                ORDER BY book_title ASC";
                
                $stmt = $pdo->prepare($query);
                $stmt->execute(['category' => $category]);
            } else {
                $query = "SELECT 
                    id, book_title, book_author, isbn, category, publication_year, available_copies, total_copies
                FROM library_books
                ORDER BY book_title ASC";
                
                $stmt = $pdo->prepare($query);
                $stmt->execute();
            }
            
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'books' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
    elseif ($action === 'getStudentBorrowings') {
        $studentId = isset($_GET['student_id']) ? intval($_GET['student_id']) : 1;
        
        try {
            $query = "SELECT 
                b.id, b.borrow_date, b.due_date, b.return_date, b.status, b.fine_amount,
                bk.book_title, bk.book_author, bk.isbn
            FROM library_borrowing b
            JOIN library_books bk ON b.book_id = bk.id
            WHERE b.student_id = :student_id
            ORDER BY b.borrow_date DESC";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute(['student_id' => $studentId]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'borrowings' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
}
?>
