<?php
// api_report_card.php - Report Card API Endpoint

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

$request_method = $_SERVER['REQUEST_METHOD'];
$action = isset($_GET['action']) ? $_GET['action'] : '';

// Database connection
$db_host = 'localhost';
$db_user = 'root';
$db_pass = '';
$db_name = 'school_portal';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit();
}

if ($request_method === 'GET') {
    if ($action === 'getReportCard') {
        $studentId = isset($_GET['student_id']) ? intval($_GET['student_id']) : 1;
        
        try {
            $query = "SELECT 
                rc.id, rc.session_year, rc.term, rc.overall_gpa, rc.class_position, 
                rc.total_students_in_class, rc.conduct_grade, rc.attendance_percentage,
                rc.class_teacher_comment, rc.principal_comment, rc.promotion_status
            FROM report_card rc
            WHERE rc.student_id = :student_id
            ORDER BY rc.session_year DESC, rc.term DESC";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute(['student_id' => $studentId]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'report_cards' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
    elseif ($action === 'getLatestReportCard') {
        $studentId = isset($_GET['student_id']) ? intval($_GET['student_id']) : 1;
        
        try {
            $query = "SELECT 
                rc.id, rc.session_year, rc.term, rc.overall_gpa, rc.class_position, 
                rc.total_students_in_class, rc.conduct_grade, rc.attendance_percentage,
                rc.class_teacher_comment, rc.principal_comment, rc.promotion_status,
                s.full_name as student_name
            FROM report_card rc
            JOIN students s ON rc.student_id = s.id
            WHERE rc.student_id = :student_id
            ORDER BY rc.session_year DESC, rc.term DESC
            LIMIT 1";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute(['student_id' => $studentId]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'report_card' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
}
?>
