<?php
// api_timetable.php - Timetable API Endpoint

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

$request_method = $_SERVER['REQUEST_METHOD'];
$action = isset($_GET['action']) ? $_GET['action'] : '';

// Database connection
$db_host = 'localhost';
$db_user = 'root';
$db_pass = '';
$db_name = 'school_portal';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit();
}

if ($request_method === 'GET') {
    if ($action === 'getTimetable') {
        $classId = isset($_GET['class_id']) ? intval($_GET['class_id']) : 1;
        
        try {
            $query = "SELECT 
                t.id, t.day_of_week, t.start_time, t.end_time, t.room_number,
                s.subject_name, s.subject_code,
                u.full_name as teacher_name
            FROM timetable t
            JOIN subjects s ON t.subject_id = s.id
            LEFT JOIN users u ON t.teacher_id = u.id
            WHERE t.class_id = :class_id
            ORDER BY FIELD(t.day_of_week, 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'),
                     t.start_time";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute(['class_id' => $classId]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'timetable' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
    elseif ($action === 'getSubjects') {
        $classId = isset($_GET['class_id']) ? intval($_GET['class_id']) : 1;
        
        try {
            $query = "SELECT 
                s.id, s.subject_name, s.subject_code, s.credit_hours, s.is_compulsory,
                u.full_name as teacher_name
            FROM subjects s
            LEFT JOIN users u ON s.teacher_id = u.id
            WHERE s.class_id = :class_id";
            
            $stmt = $pdo->prepare($query);
            $stmt->execute(['class_id' => $classId]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            http_response_code(200);
            echo json_encode(['success' => true, 'subjects' => $result]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }
}
?>
