<?php
/**
 * Generate Password Hash
 * Run this in browser: http://localhost/Backend_school_portal/generate_password_hash.php
 * To get the correct hash for your password
 */

$password = "12345678";
$hash = password_hash($password, PASSWORD_BCRYPT);

echo "<h1>Password Hash Generator</h1>";
echo "<p><strong>Password:</strong> " . htmlspecialchars($password) . "</p>";
echo "<p><strong>Hash:</strong> <code>" . htmlspecialchars($hash) . "</code></p>";
echo "<p>Copy the hash above and use it in demo_data.sql</p>";

// Verify it works
echo "<h2>Verification:</h2>";
if (password_verify($password, $hash)) {
    echo "<p style='color: green;'><strong>✅ VERIFIED:</strong> Password matches hash!</p>";
} else {
    echo "<p style='color: red;'><strong>❌ FAILED:</strong> Password does NOT match hash!</p>";
}
?>
